/*
  https://www.semesin.com
*/

#ifndef Bluetooth_Apk_Semesin_H
#define Bluetooth_Apk_Semesin_H

#define softwareSerialOrNotSerialSW 	1
#define debug							0

#include <Wire.h>
#include "EEPROM.h"

#ifdef ESP32
#include "BluetoothSerial.h"
#endif

#if softwareSerialOrNotSerialSW
#  if !defined(ESP32)
#include <SoftwareSerial.h>
#  endif
#else
#include <SerialSW.h>
#endif

#define I2CEEPROM_ADDRESS       0x57  //Perhatikan alamat I2CEEPROM 0x50(ds1307 .. 0x57(ds3231))
#define ukuranBlockI2CEEPROM  	16

union intByte
{
  byte data8[2];
  uint16_t data16;
};

struct BluetoothApkData
{
  byte perintah;
  byte parameter;
  uint16_t panjang;
  uint8_t checksum;
  uint8_t tokenSelesai;
  char key[16];
};




class BluetoothApk
{
    Stream *bluetooth;
	
  public:
    BluetoothApkData data;
	uint8_t responOK = 251;
	uint8_t responNull = 7;
	uint8_t responDiscard = 239;

    BluetoothApk(HardwareSerial *bt, char *keyBt)
    {
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
    BluetoothApk(HardwareSerial *bt, char *keyBt, uint32_t baudRate)
    {
      bt->begin(baudRate);
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
#if softwareSerialOrNotSerialSW
#  if !defined(ESP32)
    BluetoothApk(SoftwareSerial *bt, char *keyBt)
    {
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
    BluetoothApk(SoftwareSerial *bt, char *keyBt, uint32_t baudRate)
    {
      bt->begin(baudRate);
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
#  endif
#else

    BluetoothApk(SerialSW *bt, char *keyBt)
    {
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
    BluetoothApk(SerialSW *bt, char *keyBt, uint32_t baudRate)
    {
      bt->begin(baudRate);
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
#endif

#ifdef ESP32
    BluetoothApk(BluetoothSerial *bt, char *keyBt)
    {
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }
    BluetoothApk(BluetoothSerial *bt, char *keyBt, String nama)
    {
      bt->begin(nama);
      bluetooth = bt;
	  strncpy(data.key, keyBt, sizeof(data.key));
    }

#endif

    bool cekTransmisi()
    {
      while (bluetooth->available())
      {
        byte b = bluetooth->read();
#if debug
          Serial.print("b= ");
          Serial.println(b);
#endif
        if (b == 253)
        {
          byte perintah;
          byte parameter;
          byte koreksi;
          intByte panjang;

          perintah = bluetoothRead();
          parameter = bluetoothRead();
          panjang.data8[0] = bluetoothRead();
          panjang.data8[1] = bluetoothRead();
          koreksi = bluetoothRead();
		  
#if debug
          Serial.print("perintah= ");
          Serial.println(perintah);
          Serial.print("parameter= ");
          Serial.println(parameter);
          Serial.print("panjang= ");
          Serial.println(panjang.data16);
          Serial.print("koreksi= ");
          Serial.println(koreksi);
#endif
			

          if (koreksi == (byte)(panjang.data8[0] + panjang.data8[1] + 252))
          {
            data.perintah = perintah;
            data.panjang = panjang.data16;
            data.parameter = parameter;
            return true;

          }
        }
      }
      return false;
    }

    bool ambilBuffer(void *buffer, uint16_t ukuranBufferMaksimal)
    {
      if (data.panjang > ukuranBufferMaksimal)
      {
        data.panjang = ukuranBufferMaksimal;
      }

      uint8_t i;
      uint8_t checksum = 0;
	  byte *alamat = (byte*)buffer;

      for (i = 0; i < data.panjang; i++)
      {
        byte dataByte = decode(bluetoothRead(), i);
		
        *alamat++ = dataByte;
        checksum += dataByte;
      }
	  
	  data.checksum = bluetoothRead();
	  data.tokenSelesai = bluetoothRead();

	  return (checksum == data.checksum) && (data.tokenSelesai == 0);
	}

    bool ambilData(void *buffer, uint16_t ukuranBufferMaksimal)
    {
	  return konfirmasi(ambilBuffer(buffer, ukuranBufferMaksimal));
    }

    bool ambilDataEEPROM(uint16_t alamatEEPROM, uint16_t ukuranBufferMaksimal)//EEPROM
    {
      if (data.panjang > ukuranBufferMaksimal)
      {
        data.panjang = ukuranBufferMaksimal;
      }

	  uint16_t i;
	  uint8_t checksum = 0;
	  for (i = 0; i < data.panjang; i++)
 	  {
	    uint8_t dataByte =  decode(bluetoothRead(), i);
#ifdef __AVR__
	    EEPROM.update(alamatEEPROM++, dataByte);
#else
	    EEPROM.write(alamatEEPROM++, dataByte);
#endif
	    checksum += dataByte;
	  }

#ifndef __AVR__
	  EEPROM.commit();
#endif		

	  data.checksum = bluetoothRead();
	  data.tokenSelesai = bluetoothRead();
	
	  return (checksum == data.checksum) && (data.tokenSelesai == 0);
    }
	
    bool ambilDataI2CEEPROM(uint16_t alamatI2CEEPROM, uint16_t ukuranBufferMaksimal)//EEPROM
    {
      if (data.panjang > ukuranBufferMaksimal)
      {
        data.panjang = ukuranBufferMaksimal;
      }

      uint16_t i;
      uint8_t checksum = 0;

      Wire.beginTransmission(I2CEEPROM_ADDRESS);
      Wire.write((uint8_t)(alamatI2CEEPROM >> 8));
      Wire.write((uint8_t)(alamatI2CEEPROM & 0xFF));

      for (i = 0; i < data.panjang; i++)
      {
        uint8_t dataByte =  decode(bluetoothRead(), i);;
        checksum += dataByte;
        Wire.write(dataByte);
        alamatI2CEEPROM++;
        if (!(alamatI2CEEPROM % ukuranBlockI2CEEPROM))
        {
          Wire.endTransmission();
          delay(10);
          Wire.beginTransmission(I2CEEPROM_ADDRESS);
          Wire.write((uint8_t)(alamatI2CEEPROM >> 8));
          Wire.write((uint8_t)(alamatI2CEEPROM & 0xFF));
        }
      }
      if (alamatI2CEEPROM % ukuranBlockI2CEEPROM)
      {
        Wire.endTransmission();
      }

	  data.checksum = bluetoothRead();
	  data.tokenSelesai = bluetoothRead();

      return (checksum == data.checksum) && (data.tokenSelesai == 0);
    }


	bool konfirmasi(bool status)
	{
      if (status)
      {
		responData(responOK, 1);
        return true;
      }
	  else
      {
		responData(responNull, 1);
        return false;
      }
	}
	
    bool responData(void *bufferKirim, uint16_t ukuranKirim)
    {
      uint8_t checksum = 0;
      bluetooth->write((byte)253);
      bluetooth->write(ukuranKirim >> 0);
      bluetooth->write(ukuranKirim >> 8);
      bluetooth->write((byte)((ukuranKirim >> 8) + (ukuranKirim >> 0) + 252));
	  
	  byte *alamat = (byte*)bufferKirim;

      for (uint16_t i = 0; i < ukuranKirim; i++)
      {
		byte dataKirim = *alamat++;
        checksum += dataKirim;
        bluetooth->write(encode(dataKirim, i));
      }
      bluetooth->write(checksum);
      bluetooth->write((byte)0);
    }

    bool responDataEEPROM(uint16_t alamatEEPROM, uint16_t ukuranKirim)
    {
      uint8_t checksum = 0;
      bluetooth->write((byte)253);
      bluetooth->write(ukuranKirim >> 0);
      bluetooth->write(ukuranKirim >> 8);
      bluetooth->write((byte)((ukuranKirim >> 8) + (ukuranKirim >> 0) + 252));

      for (uint16_t i = 0; i < ukuranKirim; i++)
      {
        byte dataKirim = EEPROM.read(alamatEEPROM + i);
        checksum += dataKirim;
        bluetooth->write(encode(dataKirim, i));
      }
      bluetooth->write(checksum);
      bluetooth->write((byte)0);
    }

    bool responDataI2CEEPROM(uint16_t alamatI2CEEPROM, uint16_t ukuranKirim)
    {
      uint8_t checksum = 0;
      bluetooth->write((byte)253);
      bluetooth->write(ukuranKirim >> 0);
      bluetooth->write(ukuranKirim >> 8);
      bluetooth->write((byte)((ukuranKirim >> 8) + (ukuranKirim >> 0) + 252));


      for (uint16_t i = 0; i < ukuranKirim / ukuranBlockI2CEEPROM; i++)
      {
        Wire.beginTransmission(I2CEEPROM_ADDRESS);
        Wire.write((uint8_t)(alamatI2CEEPROM >> 8));
        Wire.write((uint8_t)(alamatI2CEEPROM & 0xFF));
        Wire.endTransmission();
        Wire.requestFrom((byte)I2CEEPROM_ADDRESS, (byte)ukuranBlockI2CEEPROM);

        byte dataKirim;
        for (uint8_t j = 0; j < ukuranBlockI2CEEPROM; j++)
        {
            dataKirim = Wire.read();
            checksum += dataKirim;
            bluetooth->write(encode(dataKirim, j));
        }
        alamatI2CEEPROM += ukuranBlockI2CEEPROM;
      }

      Wire.beginTransmission(I2CEEPROM_ADDRESS);
      Wire.write((uint8_t)(alamatI2CEEPROM >> 8));
      Wire.write((uint8_t)(alamatI2CEEPROM & 0xFF));
      Wire.endTransmission();

      uint8_t ukuranData = ukuranKirim % ukuranBlockI2CEEPROM;
      Wire.requestFrom((byte)I2CEEPROM_ADDRESS, ukuranData);

      byte dataKirim;
      for (uint8_t i = 0; i < ukuranData; i++)
      {
        dataKirim = Wire.read();
        checksum += dataKirim;
        bluetooth->write(encode(dataKirim, i));
      }

      bluetooth->write(checksum);
      bluetooth->write((byte)0);
    }
    byte bluetoothRead()
    {
      uint16_t timeOut = 0xFFF;
      while (!bluetooth->available() && --timeOut);
      return bluetooth->read();
    }
	byte encode(byte dataEncode, byte index)
	{
		return ((dataEncode xor data.key[index%8]) + data.key[(index%4)+8]) xor data.key[(index%4)+12];
	}
	byte decode(byte dataDecode, byte index)
	{
		return ((dataDecode xor data.key[(index%4)+12]) - data.key[(index%4)+8]) xor data.key[index%8];
	}

};


#endif